/******************************************************************************/
#include "stdafx.h"
#include "../../../../../data/enum/_enums.h"
/******************************************************************************/
struct Marker2 : Marker // create a helper class which bases on Marker and uses time fading
{
   Flt time; // time left until overlay fades out

   Marker2()
   {
      time=10; // default time is 10 seconds for an overlay to live
   }

   Bool update()
   {
             time-=Tm.d; // decrease time left
      return time<=0   ; // if there is no time left then return true (which means that the overlay can be deleted)
   }
   void draw(Matrix &matrix)
   {
      Marker::draw(matrix,Sat(time)); // draw the overlay with transparency of 'Saturate(time)' value
   }

   // io
   void save(File &f)
   {
      Marker::save(f);
      f<<time;
   }
   Bool load(File &f)
   {
      if(Marker::load(f))
      {
         f>>time;
         return true;
      }
      return false;
   }
};
/******************************************************************************/
struct Item : Game::Item // extend items
{
   Memb<Marker2> marker; // add marker, which is used for rendering semi transparent images on solid surfaces

   virtual Bool update(); // extend updating to include 'marker' update
   virtual void draw  (); // extend drawing  to include rendering of 'marker'

   // io
   virtual void save(File &f); // extend saving  to include members saving
   virtual Bool load(File &f); // extend loading to include members loading

   // operations
   void addBulletHole(Vec &pos,Vec &normal); // helper method for adding a bullet hole (Marker) onto the item mesh
};
/******************************************************************************/
Game::ObjMemx<Item> Items;
/******************************************************************************/
// ITEM
/******************************************************************************/
Bool Item::update()
{
   REPA(marker)if(marker[i].update()) // update all overlays
      marker.remove(i,true); // and remove them if they faded out

   return __super::update();
}
/******************************************************************************/
void Item::draw()
{
   __super::draw(); // call default drawing

   switch(Renderer())
   {
      case RM_OVERLAY: // overlays need to be rendered in RM_OVERLAY mode
         REPAO(marker).draw(matrixScaled()); // draw mesh_overlays with the same matrix used for default item drawing
      break;
   }
}
/******************************************************************************/
void Item::save(File &f)
{
   __super::save(f);

   marker.save(f);
}
Bool Item::load(File &f)
{
   if(__super::load(f))
   {
      return marker.load(f);
   }
   return false;
}
/******************************************************************************/
void Item::addBulletHole(Vec &pos,Vec &normal)
{
   // add a marker to the item
   marker.New().set(WHITE,*Gfxs("gfx/hole/bullet.gfx"),0.1f,0.05f,0.05f).matrix(matrixScaled(),Matrix().setPosDir(pos,normal));

   // add impulse to the actor
   actor.addImpulse(normal * -1.5f);
}
/******************************************************************************/
// MAIN
/******************************************************************************/
void InitPre()
{
   App.name="Small Overlays";
   App.flag=APP_FULL_TOGGLE|APP_MS_EXCLUSIVE;
   IOPath="../data/";
   PakAdd("engine.pak");

   D.full(true).sync(true).shdMapSize(1024).ambPower(0.3);

   ViewportFull.range=70;
   Cam.at.set(16,2,12);
   Cam.dist = 0.01;
   Cam.pitch=-0.2f;
}
/******************************************************************************/
Bool Init()
{
   Physics.create();
   Sun    .set   (*Gfxs("gfx/sky/sun.gfx")).power=1-D.ambPower(); Sun.rays.mode=SUN_RAYS_HIGH;
   Sky    .set   ();

   Game::World.init   (                     )
              .setItem(Items,OBJ_ITEM       )
              .New    ("world/custom params");

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;

   // update the camera FPP 'WSAD' style
   if(Kb.b(KB_A     ))Cam.at-=Cam.matrix.x*Tm.d*2;
   if(Kb.b(KB_D     ))Cam.at+=Cam.matrix.x*Tm.d*2;
   if(Kb.b(KB_S     ))Cam.at-=Cam.matrix.z*Tm.d*2;
   if(Kb.b(KB_W     ))Cam.at+=Cam.matrix.z*Tm.d*2;
   if(Kb.b(KB_LSHIFT))Cam.at-=Vec(0,1,0)  *Tm.d*2;
   if(Kb.b(KB_SPACE ))Cam.at+=Vec(0,1,0)  *Tm.d*2;
   CamHandle(0.01,0.01,CAMH_ROT); // allow only rotation

   Game::World.update(Cam.at);

   if(Ms.bp(0)) // on LMB pressed
   {
      // calculate world position and direction vectors
      Vec     pos, dir; ScreenToPosDir(Vec2(0,0),pos,dir);
      PhysHit phys_hit; if(Physics.ray(pos,dir*Viewport.range,&phys_hit)) // if ray test hit an actor
      {
         if(phys_hit.obj) // if the actor comes from an object
         {
            if(Item *item=CAST(Item,phys_hit.obj)) // if the object is an item
            {
               item->addBulletHole(phys_hit.plane.p, phys_hit.plane.n); // call item method to add a bullet hole
            }
         }
         else // the actor doesn't have an object set, so most probably it's a terrain actor
         {
            // add a marker to the world terrain
            Game::World.terrainAddMarker(WHITE,*Gfxs("gfx/hole/bullet.gfx"),Matrix().setPosDir(phys_hit.plane.p, phys_hit.plane.n),0.1f,0.05f,0.05f);
         }
      }
   }

   return true;
}
/******************************************************************************/
void Render()
{
   Game::World.draw();
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,"Press LMB to shoot");

   // draw simple crosshair
   D.lineX(RED, 0, -0.1f,0.1f);
   D.lineY(RED, 0, -0.1f,0.1f);
}
/******************************************************************************/
